/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.worldgen.ModWorldGen;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_6797;
import net.minecraft.class_6798;

public class WaystonePlacement
extends class_6797 {
    public static final MapCodec<WaystonePlacement> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2902.class_2903.field_24772.fieldOf("heightmap").forGetter(placement -> placement.heightmap)).apply((Applicative)builder, WaystonePlacement::new));
    private final class_2902.class_2903 heightmap;

    public WaystonePlacement() {
        this(class_2902.class_2903.field_13195);
    }

    public WaystonePlacement(class_2902.class_2903 heightmap) {
        this.heightmap = heightmap;
    }

    public Stream<class_2338> method_14452(class_5444 context, class_5819 random, class_2338 pos) {
        if (this.isWaystoneChunk(context, pos)) {
            int z;
            if (context.method_34383().method_8410().method_27983() == class_1937.field_25180) {
                class_2338.class_2339 mutablePos = pos.method_25503();
                int topMostY = context.method_30460(this.heightmap, pos.method_10263(), pos.method_10260());
                mutablePos.method_33098(topMostY);
                class_2680 stateAbove = context.method_34383().method_8320((class_2338)mutablePos);
                for (int i = mutablePos.method_10264(); i >= 1; --i) {
                    mutablePos.method_33098(mutablePos.method_10264() - 1);
                    class_2680 state = context.method_34383().method_8320((class_2338)mutablePos);
                    if (!state.method_26215() && state.method_26227().method_15769() && stateAbove.method_26215() && !state.method_27852(class_2246.field_9987)) {
                        mutablePos.method_33098(mutablePos.method_10264() + 1);
                        break;
                    }
                    stateAbove = state;
                }
                return mutablePos.method_10264() > 0 ? Stream.of(mutablePos) : Stream.empty();
            }
            int x = pos.method_10263();
            int y = context.method_30460(this.heightmap, x, z = pos.method_10260());
            return y > context.method_33868() ? Stream.of(new class_2338(x, y, z)) : Stream.of(new class_2338[0]);
        }
        return Stream.empty();
    }

    public class_6798<?> method_39615() {
        return (class_6798)ModWorldGen.waystonePlacement.get();
    }

    private boolean isWaystoneChunk(class_5444 world, class_2338 pos) {
        int chunkDistance = WaystonesConfig.getActive().worldGen.chunksBetweenWildWaystones;
        if (chunkDistance == 0) {
            return false;
        }
        class_2960 dimension = world.method_34383().method_8410().method_27983().method_29177();
        Set<class_2960> dimensionAllowList = WaystonesConfig.getActive().worldGen.wildWaystonesDimensionAllowList;
        Set<class_2960> dimensionDenyList = WaystonesConfig.getActive().worldGen.wildWaystonesDimensionDenyList;
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension)) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && dimensionDenyList.contains(dimension)) {
            return false;
        }
        int maxDeviation = (int)Math.ceil((float)chunkDistance / 2.0f);
        int chunkX = pos.method_10263() / 16;
        int chunkZ = pos.method_10260() / 16;
        int devGridX = pos.method_10263() / 16 * maxDeviation;
        int devGridZ = pos.method_10260() / 16 * maxDeviation;
        long seed = world.method_34383().method_8412();
        Random random = new Random(seed * (long)devGridX * (long)devGridZ);
        int chunkOffsetX = random.nextInt(maxDeviation);
        int chunkOffsetZ = random.nextInt(maxDeviation);
        return (chunkX + chunkOffsetX) % chunkDistance == 0 && (chunkZ + chunkOffsetZ) % chunkDistance == 0;
    }
}

